getwd()
setwd(dirname(rstudioapi::getActiveDocumentContext()$path))

## Packages
set.seed(717)
library(cubature)
library(lava) 
library(ggplot2)
library(mcGlobaloptim) 
library(DiceKriging) 
library(nloptr) 
library(MASS)
library(mcmc)
library(geoR)
library(RobustCalibration)
library(lhs)
library(RobustGaSP)
library(numDeriv)
library(ggplot2)
library(rTensor)
library(plotly)
library(R.matlab)
library(proxy)
library(abind)
library(scatterplot3d)
library(Matrix)
library(purrr)
library(plyr)
library(multiway)

# tempdir()
# dir.create(tempdir())
load("data4.RData")
load("c.pre.to.list.3.RData")

data.x <- data4$x0[2996:3360,]
data.y <- data4$y0[,,2996:3360]

dim.f = dim(data.y)[1:2]
d = ncol(data.x); lower.x = apply(data.x,2,min); upper.x = apply(data.x,2,max)

dim.s = c(2,2)
dim.h = prod(dim.s); dim.mode = length(dim.s)

N = nrow(data.x)
x0 = data.x; y0 = data.y

h <- function(y) sum(y)

ind.x.star = which.max(apply(y0,3,h))
h.star = apply(y0,3,h)[ind.x.star]
full.x.star = x0[ind.x.star,]

ind.x.star; h.star; full.x.star



## Kernel
norm0 <- function(x1,x2) as.matrix(dist(x1,x2,method = "Euclidean"))
norm1 <- function(x1,x2){
  nor = list()
  for(i in 1:d){
    nor[[i]] = norm0(x1[,i],x2[,i])}
  return(nor)
} 

mat0 <- function(x) matern(x, phi=1, kappa=5/2)
gau0 <- function(x) exp(-x^2)
exp0 <- function(x) exp(-abs(x))

ker.sele <- function(x1,x2,theta,ker){
  x = norm1(x1,x2)
  dis = Map(function(x0,th) x0/th,x,theta)
  R0 = Map(function(x0) ker(x0),dis)
  R = Reduce("*", R0)
  return(R)
}

B.tuck.smt <- function(y,n){
  y0 = lapply(1:n, function(i) rTensor::as.tensor(y[,,i]))
  U.tuck = list()
  
  mode.unfold <- function(da,k) do.call(cbind, lapply(da, function(x) {k_unfold(x,k)@data}))
  for(i in 1:dim.mode) U.tuck[[i]] = svd(mode.unfold(y0, i))$u[, 1:dim.s[i]]
  core.ten = lapply(y0, function(x) ttl(x, lapply(U.tuck, t), 1:dim.mode))
  
  return(list(core.ten=core.ten, U.tuck=U.tuck))
}
# b.ren = B.tuck.smt(y,n)



################################################################################
#### GP ########################################################################
################################################################################

################################################################################
## Our proposed method: NS-TOGP
vec.lab = list()
for(om.lab in 1:dim.mode){
  vec.lab[[om.lab]] = dim.s[om.lab]*(dim.s[om.lab]+1)/2
}
vec.lab[[dim.mode+1]] = d
vec.lab[[dim.mode+2]] = vec.lab[[dim.mode+3]] = 1
group.lab <- unlist(Map(rep, LETTERS[1:length(vec.lab)], unlist(vec.lab)))
dim.hyper.smt = length(group.lab)

lower.th = c(unlist(Map(rep, c(rep(1e-1,dim.mode),1e-3,1e-2,1e-10), unlist(vec.lab))))
upper.th = c(unlist(Map(rep, c(rep(1,dim.mode),10,10,1e-2), unlist(vec.lab))))

sig.smt <- function(t,ome){
  O = matrix(0,t,t)
  O[lower.tri(O, diag = TRUE)] <- ome
  return(O)
}

ker.smt <- function(y,n,the){
  the0 = split(the, group.lab)
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],the0[[i]])
  
  sig = lapply(Omega,function(the) sig.smt(the[[1]],the[[2]]))
  sig.tuck = Map(function(B) B%*%t(B), sig)
  return(Reduce(kronecker,sig.tuck))
}


likeli.smt <- function(x1,x2,y,n,the){
  the0 = split(the, group.lab); th = the0[[dim.mode+1]]
  sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  omega = ker.smt(y,n,the)
  k.ini = kronecker(ker.sele(x1,x2,th,mat0),omega)
  
  log.likeli = determinant(sig2*k.ini+tau2*diag(n*dim.h),logarithm=TRUE)$modulus+
    t(c(y))%*%solve(sig2*k.ini+tau2*diag(n*dim.h))%*%c(y)
  return(list(like=log.likeli, the0=the0))
}

EIJ <- function(i,j,l){
  E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,j] = 1
  return(E0)
}

der.l <- function(x1,x2,y,n,the){
  the0 = split(the, group.lab)
  
  ome = list()
  for(i in 1:dim.mode){ome[[i]] = the0[[i]]}
  
  th = the0[[dim.mode+1]]; sig2 = the0[[dim.mode+2]]; tau2 = the0[[dim.mode+3]]
  
  J <- function(i,l){
    E0 = matrix(0,dim.s[l],dim.s[l]); E0[i,i] = exp(sig.smt(dim.s[l],ome[[l]])[i,i])
    return(E0)
  }
  
  Omega = list()
  for(i in 1:dim.mode) Omega[[i]] = list(dim.s[i],ome[[i]])
  
  sig = lapply(Omega,function(the) sig.smt(the[[1]],the[[2]]))
  sig.tuck = Map(function(B) B%*%t(B), sig)
  omega = Reduce(kronecker,sig.tuck)
  
  k.ini = ker.sele(x1,x2,th,mat0)
  al.k1 = kronecker(k.ini,omega)
  
  k.y = sig2*al.k1+tau2*diag(n*dim.h)
  sol.k.y = solve(k.y)
  
  al.k = sol.k.y%*%c(y)
  der.l.sig2 = tr(sol.k.y%*%al.k1)-t(al.k)%*%al.k1%*%al.k
  der.l.tau2 = tr(sol.k.y)-t(al.k)%*%al.k
  
  der.th = array(jacobian(function(theta) ker.sele(x1,x2,theta,mat0), th),dim=c(n,n,d))
  der.l.th.i <- function(der) sig2*(tr(sol.k.y%*%kronecker(der,omega))-
                                      t(al.k)%*%kronecker(der,omega)%*%al.k)
  der.l.th = apply(der.th,3,der.l.th.i)
  
  der.l.phi = list()
  for(l in 1:dim.mode){
    der.l.phi[[l]] = matrix(0, dim.s[l], dim.s[l])
    
    der.l.phi.ij <- function(i,j) EIJ(i,j,l)%*%t(sig[[l]])+sig[[l]]%*%EIJ(j,i,l)
    it1 <- function(der.p){
      list1 = if (l > 1) sig.tuck[1:(l-1)] else 1
      list2 = if (l < dim.mode) sig.tuck[(l+1):dim.mode] else 1
      kro.list = list(sig2*k.ini,Reduce(kronecker,list1),der.p,Reduce(kronecker,list2))
      return(Reduce(kronecker,kro.list))
    } 
    it2 <- function(der.p) tr(sol.k.y%*%it1(der.p))-t(al.k)%*%it1(der.p)%*%al.k
    
    der.l.phi.1 = sapply(c(1:dim.s[l]), function(i) {
      sapply(c(1:i), function(j) it2(der.l.phi.ij(i, j)))
    })
    
    der.l.phi.ii <- function(i) J(i,l)%*%t(sig[[l]])+sig[[l]]%*%J(i,l)
    der.l.phi.dig = apply(as.matrix(c(1:dim.s[l])),1, function(i) it2(der.l.phi.ii(i)))
    
    for (i in 1:dim.s[l]) {
      der.l.phi[[l]][i, 1:i] <- der.l.phi.1[[i]]
    }
    # diag(der.l.phi[[l]]) = der.l.phi.dig   
  }
  
  result = list(der.l.phi=lapply(der.l.phi, function(mat) mat[lower.tri(mat, diag = TRUE)]), 
                der.l.th=der.l.th, der.l.sig2=der.l.sig2, der.l.tau2=der.l.tau2)
  return(result)
}
# der.l(x,x,y,k.ind,n,s1,s2,s3,runif(dim.hyper.smt))

smtgp.hat <- function(x.new,x,y,n,n.test,hy){
  th = hy[[dim.mode+1]]
  sig2 = hy[[dim.mode+2]]; tau2 = hy[[dim.mode+3]]
  
  x.new = matrix(x.new,n.test,d)
  omega = ker.smt(y,n,unlist(hy))
  
  k.smt.s0 = kronecker(ker.sele(x,x,th,mat0),omega)
  k.smt.s = sig2*k.smt.s0+tau2*diag(n*dim.h)
  
  k.smt.10 = ker.sele(x.new,x,th,mat0)
  k.smt.1 = sig2*kronecker(k.smt.10,omega)
  
  k.smt.00 = ker.sele(x.new,x.new,th,mat0)
  k.smt.0 = sig2*kronecker(k.smt.00,omega)
  
  k.oth = k.smt.1%*%solve(k.smt.s)
  
  f.hat.tuck = k.oth%*%c(y)
  var.hat.tuck = k.smt.0-k.oth%*%t(k.smt.1)
  
  result = list(mean.tuck = f.hat.tuck, cov.tuck = var.hat.tuck)
  return(result)
}


n.train = pre.to.list$n.train; n.test = pre.to.list$n.test
ind.train = pre.to.list$ind.train; ind.test = pre.to.list$ind.test

x.train = pre.to.list$x.train; y.train = pre.to.list$y.train
x.test = pre.to.list$x.test; y.test = pre.to.list$y.test

B.tuck.train = pre.to.list$B.tuck.train
y0.train = pre.to.list$y0.train

hyper.smt.train.ini = directL(function(the) likeli.smt(x.train,x.train,y0.train,n.train,the)$like,
                              lower.th,upper.th,control=list(maxeval=1000))$par
hyper.smt.train = optim(par = hyper.smt.train.ini,
                       fn = function(the) likeli.smt(x.train,x.train,y0.train,n.train,the)$like,
                       gr = function(the) unlist(der.l(x.train,x.train,y0.train,n.train,the)),
                       method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par

likeli.train = -0.5*likeli.smt(x.train,x.train,y0.train,n.train,hyper.smt.train)$like
hy.smt.train = likeli.smt(x.train,x.train,y0.train,n.train,hyper.smt.train)$the0

pre.smt.train = smtgp.hat(x.train,x.train,y0.train,n.train,n.train,hy.smt.train)

mean.tuck.smt.train = pre.smt.train$mean.tuck
var.tuck.hat.smt.train = pre.smt.train$cov.tuck

mean(abs((mean.tuck.smt.train-c(y0.train))/c(y0.train)))
sqrt(Matrix::norm(var.tuck.hat.smt.train,type="2"))

pre.smt.test = smtgp.hat(x.test,x.train,y0.train,n.train,n.test,hy.smt.train)
mean.smt.test = pre.smt.test$mean.tuck
var.hat.smt.test = pre.smt.test$cov.tuck

B.test = kronecker(diag(n.test),B.tuck.train)
mse.smt = mean((B.test%*%mean.smt.test-c(y.test))^2)
cov.op = sqrt(Matrix::norm(B.test%*%var.hat.smt.test%*%t(B.test),type="2"))
mse.smt; cov.op

pre.smt.list = list(n.train=n.train, n.test=n.test, ind.train=ind.train, ind.test=ind.test,
                   x.train=x.train, y.train=y.train, x.test=x.test, y.test=y.test,
                   B.tuck.train=B.tuck.train, y0.train=y0.train,
                   nll.smt=likeli.train, mse.smt=mse.smt, cov.op=cov.op)
save(pre.smt.list, file="c.pre.smt.list.RData")








################################################################################
## Our proposed method: NS-TOGP-UCB
n = c.ini.set$n; m = c.ini.set$m; J.for = c.ini.set$J.for

like.re.smt = hyper.smt = fhat = lapply(1:J.for, function(x) list())
x0.smt = y0.smt = y0.tuck.smt = ind.x.smt = list()
smtgp.bo = h.smt = list()
regret.smt = ins.regret.smt = cum.regret.smt = list()
beta.smt = ucb.new.smt = lapply(1:J.for, function(x) list())

for(j.for.smt in 1:J.for){
  
  ind.x = c.ini.set$ind.x.for[[j.for.to]]
  x = data.x[ind.x,]; y=y0[,,ind.x]
  
  y0.tuck = B.tuck.smt(y,n); B.tuck = Reduce(kronecker,y0.tuck$U.tuck)
  y0.0 = lapply(y0.tuck$core.ten, function(c) c@data)
  y.tuck = abind(y0.0, along = dim.mode+1)
  
  
  ## Setting
  ######################################## BO ####################################
  hyper.smt.old = directL(function(the) likeli.smt(x,x,y.tuck,n,the)$like,
                          lower.th,upper.th,control=list(maxeval=1000))$par
  hyper.smt.new = optim(par = hyper.smt.old,
                        fn = function(the) likeli.smt(x,x,y.tuck,n,the)$like,
                        gr = function(the) unlist(der.l(x,x,y.tuck,n,the)),
                        method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
  
  like.re.smt[[j.for.smt]][[1]] = likeli.smt(x,x,y.tuck,n,hyper.smt.new)
  hyper.smt[[j.for.smt]][[1]] = like.re.smt[[j.for.smt]][[1]]$the0
  
  x0 = data.x; inx0 = c(1:N)
  x0.smt[[j.for.smt]] = x; y0.smt[[j.for.smt]] = y; ind.x.smt[[j.for.smt]] = ind.x
  y0.tuck.smt[[j.for.smt]] = y.tuck; n.smt = n
  
  x.new.smt = t(as.matrix(x[which.max(apply(y,3,h)),]))
  y.new.smt = y[,,which.max(apply(y,3,h))]
  
  hyper.smt.ucb = unlist(hyper.smt[[j.for.smt]][[1]]); delta.smt = 0.05
  fhat[[j.for.smt]][[1]] = smtgp.hat(x.new.smt,x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],
                                   n.smt,1,hyper.smt[[j.for.smt]][[1]])
  
  for(i.smt in 1:m){
    sig2 = hyper.smt[[j.for.smt]][[i.smt]][[dim.mode+3]]
    eta = hyper.smt[[j.for.smt]][[i.smt]][[dim.mode+3]]
    it1 = Map(function(A) determinant(diag(dim.h)+1/eta*A[[2]],logarithm=TRUE)$modulus,fhat[[j.for.smt]])
    beta.smt[[j.for.smt]][[i.smt]] = sqrt(Matrix::norm(fhat[[j.for.smt]][[1]]$mean.tuck,type="2"))+
      sqrt(sig2/eta)*sqrt(2*log(1/delta.smt)+Reduce(sum,it1))
   
    ucb.smt <- function(x.new,beta){
      x.new = matrix(x.new,1,d)
      smtgp.output = smtgp.hat(x.new,x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],
                               n.smt,n.test=1,hyper.smt[[j.for.smt]][[i.smt]])
      ucb = sum(B.tuck%*%smtgp.output$mean.tuck)+beta*sqrt(Matrix::norm(B.tuck%*%smtgp.output$cov.tuck%*%t(B.tuck),type="2"))
      return(ucb)
    }
    
    ucb.x = apply(x0[-ind.x.smt[[j.for.smt]],],1,function(x.new) -ucb.smt(x.new,beta.smt[[j.for.smt]][[i.smt]]))
    ind.x.new.smt = inx0[-ind.x.smt[[j.for.smt]]][which.min(ucb.x)] #which(apply(x0, 1, function(row) all(row == x0[-ind.x.smt[[j.for.smt]],][which.min(ucb.x),])))[1]
    x.new.smt = x0[ind.x.new.smt,]; y.new.smt = y0[,,ind.x.new.smt]
    y.tuck.new.smt = abind(ttl(rTensor::as.tensor(y.new.smt), 
                              lapply(y0.tuck$U.tuck,t), 1:dim.mode)@data, along=dim.mode+1)
    
    ucb.new.smt[[j.for.smt]][[i.smt]] = ucb.smt(x.new.smt,beta.smt[[j.for.smt]][[i.smt]])
    fhat[[j.for.smt]][[i.smt+1]] = smtgp.hat(x.new.smt,x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],
                                          n.smt,n.test=1,hyper.smt[[j.for.smt]][[i.smt]])
    
    x0.smt[[j.for.smt]] = rbind(x0.smt[[j.for.smt]], x.new.smt)
    y0.smt[[j.for.smt]] = abind(y0.smt[[j.for.smt]], y.new.smt, along = dim.mode+1)
    y0.tuck.smt[[j.for.smt]] = abind(y0.tuck.smt[[j.for.smt]], y.tuck.new.smt, along = dim.mode+1)
    ind.x.smt[[j.for.smt]] = c(ind.x.smt[[j.for.smt]],ind.x.new.smt)
    n.smt = n+i.smt
    
    if(i.smt %% 150 == 0){
      hyper.smt.ucb = optim(par = unlist(hyper.smt[[j.for.smt]][[i.smt]]), 
                           fn = function(the) likeli.smt(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],n.smt,the)$like, 
                           gr = function(the) unlist(der.l(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],n.smt,the)), 
                           method = "L-BFGS-B", lower=lower.th, upper=upper.th)$par
    }else{
      hyper.smt.ucb = hyper.smt.ucb
    }
    
    like.re.smt[[j.for.smt]][[i.smt+1]] = likeli.smt(x0.smt[[j.for.smt]],x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],n.smt,hyper.smt.ucb)
    hyper.smt[[j.for.smt]][[i.smt+1]] = like.re.smt[[j.for.smt]][[i.smt+1]]$the0
    print(i.smt)
  }
  smtgp.ucb <- function(x.new,ind.new) smtgp.hat(x.new,ind.new,x0.smt[[j.for.smt]],y0.tuck.smt[[j.for.smt]],
                                                 n.smt,n.test=1,hyper.smt[[j.for.smt]][[i.smt+1]]) 
  smtgp.bo[[j.for.smt]] = smtgp.ucb
  
  h.smt[[j.for.smt]] = apply(y0.smt[[j.for.smt]],dim.mode+1,h)
  regret.smt[[j.for.smt]] = h.star-h.smt[[j.for.smt]]
  
  layout(matrix(1, nrow = 1, ncol = 1))
  plot(rep(h.star,(n.smt-n+1)),type="b",lwd=3,lty=1,pch=1,col=1,ylim=c(cummax(h.smt[[j.for.smt]])[n],h.star))
  lines(cummax(h.smt[[j.for.smt]])[n:n.smt],type="b",lwd=3,lty=2,pch=2,col=2)
  
  ins.regret.smt[[j.for.smt]] = h.star-cummax(h.smt[[j.for.smt]][(n+1):n.smt])
  cum.regret.smt[[j.for.smt]] = cumsum(ins.regret.smt[[j.for.smt]])
  
  plot(cumsum(ins.regret.smt[[j.for.smt]]),type="b",lwd=3,lty=2,pch=2,col=2)

  print(j.for.smt)
}

mat <- do.call(rbind, cum.regret.smt)
cum.regret.mean <- apply(mat,2, mean)
cum.regret.lower <- apply(mat,2, function(x) quantile(x, 0.025))
cum.regret.upper <- apply(mat,2, function(x) quantile(x, 0.975))


time <- 1:m
plot(time, cum.regret.mean, type = "l", lwd = 2, col = "blue", ylim = range(c(cum.regret.lower, cum.regret.upper)),
     ylab = "Value", xlab = "Time", main = "Mean with 95% Confidence Band")
polygon(c(time, rev(time)),
        c(cum.regret.upper, rev(cum.regret.lower)),
        col = rgb(0.1, 0.2, 0.9, 0.2), border = NA)
lines(time, cum.regret.mean, col = "blue", lwd = 2)


# fsmt.ucb.list = list(ind.x.star=ind.x.star, h.star=h.star, ind.star=ind.star, ora.x.star=ora.x.star,         
#                      like.re.smt=like.re.smt, hyper.smt=hyper.smt, fhat=fhat,
#                      x0.smt=x0.smt, y0.smt=y0.smt, smtgp.bo=smtgp.bo, ind.x.smt=ind.x.smt, 
#                      h.smt=h.smt, regret.smt=regret.smt, ins.regret.smt=ins.regret.smt, cum.regret.smt=cum.regret.smt,
#                      beta.smt=beta.smt, ucb.new.smt=ucb.new.smt)
# save(fsmt.ucb.list, file="c4.fsmt.ucb.list.RData")














